﻿using System;

namespace MVC_App.Validation
{
	public static class ValidatingNodeExtensions
	{
		public static ValidatingNode<string> NotNullOrWhitespace(this ValidatingNode<string> that)
		{
			if (that.DoEvaluate)
			{
				if (string.IsNullOrWhiteSpace(that.Value))
					return that.Error("{0} wird benötigt");
			}
			return that;
		}

		public static ValidatingNode<T> NotNull<T>(this ValidatingNode<T?> that)
			where T : struct
		{
			if (that.DoEvaluate)
			{
				if (that.Value.HasValue)
					return that.DoTransform(that.Value.Value);

				that.Error("{0} wird benötigt").DoTransform(default(T));
			}
			return that.PropagateError<T>();
		}

		public static ValidatingNode<T> NotNull<T>(this ValidatingNode<T> that)
			where T : class
		{
			if (that.DoEvaluate)
			{
				if (that.Value != null)
					return that.DoTransform(that.Value);

				that.Error("{0} wird benötigt").DoTransform(default(T));
			}
			return that.PropagateError<T>();
		}

		public static ValidatingNode<int> ToInt32(this ValidatingNode<string> that)
		{
			return that.TransformGuardEx(Convert.ToInt32, "{0} ist kein gültiger Zahlenwert");
		}

		public static ValidatingNode<int> InRange(this ValidatingNode<int> that, int min, int max)
		{
			if (that.DoEvaluate)
			{
				if (that.Value > max && that.Value < min)
					return that.Error("{0} ist nicht in einem gültigen Zahlenbereich");
			}
			return that;
		}

		public static ValidatingNode<string> HasLength(this ValidatingNode<string> that, int min, int max)
		{
			if (that.DoEvaluate)
			{
				if (that.Value.Length > max)
					return that.Error("{0} ist zu lang");
				else if (that.Value.Length < min)
					return that.Error("{0} ist zu kurz");
			}
			return that;
		}

		public static ValidatingNode<string> HasLength(this ValidatingNode<string> that, int length)
		{
			if (that.DoEvaluate)
			{
				if (that.Value.Length != length)
					return that.Error("{0} muss genau " + length + " Zeichen lang sein");
			}
			return that;
		}
	}
}